/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.services;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.services.IBufferSourceFactory;
import com.anthonyhilyard.iceberg.services.IFontLookup;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.services.IKeyMappingRegistrar;
import com.anthonyhilyard.iceberg.services.IPlatformHelper;
import com.anthonyhilyard.iceberg.services.IReloadListenerRegistrar;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class Services {
    private static final ConcurrentHashMap<Class<?>, Supplier<?>> serviceCache = new ConcurrentHashMap();

    public static IPlatformHelper getPlatformHelper() {
        return (IPlatformHelper)serviceCache.computeIfAbsent(IPlatformHelper.class, x -> Services.createLazySupplier(x)).get();
    }

    public static IBufferSourceFactory getBufferSourceFactory() {
        return (IBufferSourceFactory)serviceCache.computeIfAbsent(IBufferSourceFactory.class, x -> Services.createLazySupplier(x)).get();
    }

    public static IIcebergConfigSpecBuilder getConfigSpecBuilder() {
        return (IIcebergConfigSpecBuilder)serviceCache.computeIfAbsent(IIcebergConfigSpecBuilder.class, x -> Services.createLazySupplier(x)).get();
    }

    public static IKeyMappingRegistrar getKeyMappingRegistrar() {
        return (IKeyMappingRegistrar)serviceCache.computeIfAbsent(IKeyMappingRegistrar.class, x -> Services.createLazySupplier(x)).get();
    }

    public static IReloadListenerRegistrar getReloadListenerRegistrar() {
        return (IReloadListenerRegistrar)serviceCache.computeIfAbsent(IReloadListenerRegistrar.class, x -> Services.createLazySupplier(x)).get();
    }

    public static IFontLookup getFontLookup() {
        return (IFontLookup)serviceCache.computeIfAbsent(IFontLookup.class, x -> Services.createLazySupplier(x)).get();
    }

    protected static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Iceberg.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    private static <T> Supplier<T> createLazySupplier(final Class<T> clazz) {
        return new Supplier<T>(){
            private volatile T instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.instance == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.instance == null) {
                            this.instance = Services.load(clazz);
                        }
                    }
                }
                return this.instance;
            }
        };
    }
}

